<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmailQueue extends Model 
{

    protected $table = 'email_queue';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function status()
    {
        return $this->belongsTo('App\Model\EmailSendingStatuses', 'status_id');
    }

    public function sender()
    {
        return $this->belongsTo('App\Model\Employee', 'sender_id');
    }

}